﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class Flag : Interactable
{
    public bool acquireOnlyOnce = true;

    public string[] requiredFlags;

    public string[] forbiddenFlags;

    public string flagName;

    public string[] flagsToRemoveWhenFlagIsAcquired;

    public string[] dialogTextsInactiveFlag;

    public string[] dialogTextsActivateFlag;

    public string[] dialogTextsActiveFlag;

    public GameObject[] objectsToActivateWhenFlagIsAccquired;

    public GameObject[] objectsToDeactivateWhenFlagIsAccquired;

    override public bool Interact()
    {
        return Activate();
    }

    protected bool Activate()
    {
        if (acquireOnlyOnce && GameController.instance.HasFlag(flagName))
        {
            if (dialogTextsActiveFlag.Length > 0)
            {
                GameController.instance.StartDialog(dialogTextsActiveFlag);
                return true;
            }

            return false;
        }

        bool hasRequiredFlags = true;
        foreach (string requiredFlag in requiredFlags)
        {
            if (!GameController.instance.HasFlag(requiredFlag))
            {
                hasRequiredFlags = false;
                break;
            }
        }

        foreach (string forbiddenFlag in forbiddenFlags)
        {
            if (GameController.instance.HasFlag(forbiddenFlag))
            {
                hasRequiredFlags = false;
                break;
            }
        }

        if (hasRequiredFlags)
        {
            GameController.instance.StartDialog(dialogTextsActivateFlag, () =>
            {
                GameController.instance.AddFlag(flagName, objectsToActivateWhenFlagIsAccquired, objectsToDeactivateWhenFlagIsAccquired);

                foreach (string flagToRemove in flagsToRemoveWhenFlagIsAcquired)
                {
                    GameController.instance.RemoveFlag(flagToRemove);
                }
            });

            return true;
        }
        else if (dialogTextsInactiveFlag.Length > 0)
        {
            GameController.instance.StartDialog(dialogTextsInactiveFlag);
            return true;
        }

        return false;
    }
}
